<?php
// admin/eliminar_producto.php
session_start();
require_once '../config/db.php';

// Seguridad: Solo si hay sesión y es POST
if (!isset($_SESSION['user_id']) || $_SERVER['REQUEST_METHOD'] != 'POST') {
    header("Location: productos.php");
    exit;
}

if (isset($_POST['id'])) {
    $id = $_POST['id'];

    // 1. Obtener imagen para borrar el archivo físico
    $stmt = $pdo->prepare("SELECT main_image_url FROM products WHERE id = ?");
    $stmt->execute([$id]);
    $img = $stmt->fetchColumn();

    // Borrar archivo si existe y no es el default
    if ($img && $img != 'default_product.jpg' && file_exists("../uploads/" . $img)) {
        unlink("../uploads/" . $img);
    }

    // 2. Borrar de la Base de Datos
    $stmt = $pdo->prepare("DELETE FROM products WHERE id = ?");
    $stmt->execute([$id]);
}

// Redirigir
header("Location: productos.php");
exit;
?>